#region Includes
using GroundhogLearning.GameKit.Utils;
using UnityEngine;
using UnityEngine.Events;
#endregion

namespace GroundhogLearning.GameKit.Interactions
{
    [AddComponentMenu(EditorMenuConfig.CATEGORY_INTERACTIONS + "Grab Interactable")]
    public class GrabInteractable : Interactable
    {
        #region Variables

        [Header("Configuration")]
        [Tooltip("The force to throw attached objects on detach.")]
        [SerializeField] private float _throwOnDetachForce;

        [Header("Events")]
        public UnityEvent<bool> OnGrabStateChanged;

        public bool IsGrabbed { get; private set; }

        private bool _isKinematic;

        #endregion

        protected override void Start()
        {
            base.Start();

            _isKinematic = _rigidbody.isKinematic;
        }

        public override Interactable Activate(RayInteractor interactor)
        {
            base.Activate(interactor);

            IsGrabbed = !IsGrabbed;

            _rigidbody.isKinematic = IsGrabbed || _isKinematic;
            _collider.enabled = !IsGrabbed;

            if (!IsGrabbed)
            {
                _rigidbody.AddForce(interactor.transform.forward * _throwOnDetachForce, ForceMode.Impulse);
            }

            OnGrabStateChanged?.Invoke(IsGrabbed);
            return this;
        }
    }
}